/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.OperationType;
import java.util.NoSuchElementException;

public class Operation
implements ADQLOperand {
    private ADQLOperand leftOperand;
    private OperationType operation;
    private ADQLOperand rightOperand;

    public Operation(ADQLOperand aDQLOperand, OperationType operationType, ADQLOperand aDQLOperand2) throws NullPointerException, UnsupportedOperationException {
        this.setLeftOperand(aDQLOperand);
        if (operationType == null) {
            throw new NullPointerException("Impossible to build an Operation without an operation type (SUM, SUB, MULT or DIV) !");
        }
        this.operation = operationType;
        this.setRightOperand(aDQLOperand2);
    }

    public Operation(Operation operation) throws Exception {
        this.leftOperand = (ADQLOperand)operation.leftOperand.getCopy();
        this.operation = operation.operation;
        this.rightOperand = (ADQLOperand)operation.rightOperand.getCopy();
    }

    public final ADQLOperand getLeftOperand() {
        return this.leftOperand;
    }

    public void setLeftOperand(ADQLOperand aDQLOperand) throws NullPointerException, UnsupportedOperationException {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to update an Operation with a left operand equals to NULL !");
        }
        if (!aDQLOperand.isNumeric()) {
            throw new UnsupportedOperationException("Impossible to update an Operation because the left operand is not numeric (" + aDQLOperand.toADQL() + ") !");
        }
        this.leftOperand = aDQLOperand;
    }

    public final OperationType getOperation() {
        return this.operation;
    }

    public void setOperation(OperationType operationType) {
        if (operationType != null) {
            this.operation = operationType;
        }
    }

    public final ADQLOperand getRightOperand() {
        return this.rightOperand;
    }

    public void setRightOperand(ADQLOperand aDQLOperand) throws NullPointerException, UnsupportedOperationException {
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to update an Operation with a right operand equals to NULL !");
        }
        if (!aDQLOperand.isNumeric()) {
            throw new UnsupportedOperationException("Impossible to update an Operation because the right operand is not numeric (" + aDQLOperand.toADQL() + ") !");
        }
        this.rightOperand = aDQLOperand;
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new Operation(this);
    }

    @Override
    public String getName() {
        return this.operation.toString();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;
            private ADQLOperand operand = null;

            @Override
            public ADQLObject next() {
                ++this.index;
                if (this.index == 0) {
                    this.operand = Operation.this.leftOperand;
                } else if (this.index == 1) {
                    this.operand = Operation.this.rightOperand;
                } else {
                    throw new NoSuchElementException();
                }
                return this.operand;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < 2;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                } else if (aDQLObject instanceof ADQLOperand && ((ADQLOperand)aDQLObject).isNumeric()) {
                    if (this.index == 0) {
                        Operation.this.leftOperand = (ADQLOperand)aDQLObject;
                    } else if (this.index == 1) {
                        Operation.this.rightOperand = (ADQLOperand)aDQLObject;
                    }
                } else {
                    throw new UnsupportedOperationException("Impossible to replace the operand \"" + this.operand.toADQL() + "\" by \"" + aDQLObject.toADQL() + "\" in the operation \"" + Operation.this.toADQL() + "\" because the replacer is not an ADQLOperand or is not numeric !");
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove one operand (" + this.operand.toADQL() + ") of an operation (" + Operation.this.toADQL() + "). However you can replace the whole operation by the remaining operand.");
            }
        };
    }

    @Override
    public String toADQL() {
        return this.leftOperand.toADQL() + this.operation.toADQL() + this.rightOperand.toADQL();
    }
}

